"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.exportTestResultHTML=void 0;const formatUrlForFilename_1=require("./formatUrlForFilename"),fs_1=__importDefault(require("fs"));async function exportTestResultHTML(e,t,l,s,a){const i=t.filter((e=>!e.success)),r=l.filter((e=>!e.success));var n=encodeURIComponent(a);let o=i.reduce(((e,t)=>(e[t.url]||(e[t.url]=[]),e[t.url].push(t),e)),{}),c=Object.entries(o).slice(0,50).reduce(((e,[t,l])=>(e[t]=l,e)),{});var d=Object.entries(o).length>50;fs_1.default.writeFileSync(s,`<!DOCTYPE html>\n<html lang="en">\n<head>\n  <meta charset="UTF-8">\n  <meta http-equiv="X-UA-Compatible" content="IE=edge">\n  <meta name="viewport" content="width=device-width, initial-scale=1.0">\n  <title>SEO Page Audit</title>\n  <style>\n    ${fs_1.default.readFileSync("dist/styles.css","utf8")}\n  </style>\n</head>\n<body class="font-inter antialiased bg-slate-900 text-slate-100 tracking-tight" >\n<main class="grow">\n <section>\n <div class="max-w-6xl mx-auto px-4 sm:px-6 pt-12 md:pt-20">  \n  <h1 class="h1 bg-clip-text bg-gradient-to-r from-slate-200/60 via-slate-200 to-slate-200/60 pb-4 mt-4"><img src="https://www.seopageaudit.com/images/logo.gif?utm_source=SEOPageAuditExport&utm_term=${n}" alt="SEO Page Audit Logo" width="40" height="40" style="display:inline-block;"/>SEO Page Audit</h1>\n  <h2 class="inline-flex font-large bg-clip-text bg-gradient-to-r from-purple-500 to-purple-200 pb-3">${a}</h2>\n  <h2 class="h2 bg-clip-text bg-gradient-to-r from-slate-200/60 via-slate-200 to-slate-200/60 pb-4">Summary</h2>\n  <p class="font-medium text-slate-50">${e} Pages Visited</p>\n  <p class="font-medium text-slate-50">${t.length+l.length} Total Audits</p>\n  <p class="font-medium text-slate-50">${i.length+r.length} Failed Audits</p>\n  ${d?'<p class="font-medium text-slate-50">Only the first 50 URLs are included in this report. Please see the CSV export for the full list.</p>':""}\n  <p class="text-sm text-slate-400">Created on ${(new Date).toLocaleDateString()}</p>\n  <p class="text-sm text-slate-400">Report created by Ben Maddox. Please reach out to ben@maddoxlabs.com for any questions or concerns.</p>\n  \n  <h2 class="h2 bg-clip-text bg-gradient-to-r from-slate-200/60 via-slate-200 to-slate-200/60 pb-4 mt-4">Failed Cross Page Tests</h2>\n    ${l.filter((e=>!e.success)).map((e=>`<h2 class="text-2xl text-slate-50 mt-4">${e.title}</h2><p class="text-base text-slate-400 mb-4">${e.message}</p>`)).join("")}\n\n  <h2 class="h2 bg-clip-text bg-gradient-to-r from-slate-200/60 via-slate-200 to-slate-200/60 pb-4 mt-8">Failed Page Tests</h2> \n    ${Object.entries(c).map((([e,t])=>`<h2 class="inline-flex text-2xl bg-clip-text text-transparent bg-gradient-to-r from-purple-500 to-purple-200 pb-3 mt-8">${e}</h2>${ImageToBase64Tag(`results/${(0,formatUrlForFilename_1.formatUrlForFilename)(a)}/${(0,formatUrlForFilename_1.formatUrlForFilename)(e)}.jpeg`)}`+t.map((e=>`<h4 class="text-2xl text-slate-50">${"Error"===e.audit.severity?'<svg xmlns="http://www.w3.org/2000/svg" alt="Error (High severity)" style="display: inline-block;" width="24" height="24" viewBox="0 0 48 48"><title>Error (High severity)</title><g fill="#ed0101"><path d="M45.707,14.6L33.407,2.3c-.186-.19-.441-.298-.707-.3H15.3c-.265,0-.52,.105-.707,.293L2.293,14.6c-.186,.186-.291,.437-.293,.7v17.4c0,.265,.105,.52,.293,.707l12.3,12.3c.187,.188,.442,.293,.707,.293h17.4c.265,0,.52-.105,.707-.293l12.3-12.3c.188-.187,.293-.442,.293-.707V15.3c-.002-.263-.107-.514-.293-.7Zm-21.707,23.4c-1.105,0-2-.895-2-2s.895-2,2-2,2,.895,2,2-.895,2-2,2Zm.525-8h-1.049c-.543,0-.986-.433-1-.975l-.45-18c-.014-.562,.438-1.025,1-1.025h1.949c.562,0,1.014,.463,1,1.025l-.45,18c-.014,.542-.457,.975-1,.975Z" fill="#ed0101"></path></g></svg>':"Warning"===e.audit.severity?'<svg xmlns="http://www.w3.org/2000/svg" alt="Warning (Middle severity)" style="display: inline-block;" width="24" height="24" viewBox="0 0 48 48"><title>Warning (Middle severity)</title><g fill="#face00"><path d="M46.707,14.6l-12.3-12.3A1,1,0,0,0,33.7,2H16.3a1,1,0,0,0-.707.293L3.293,14.6A1,1,0,0,0,3,15.3V32.7a1,1,0,0,0,.293.707l12.3,12.3A1,1,0,0,0,16.3,46H33.7a1,1,0,0,0,.707-.293l12.3-12.3A1,1,0,0,0,47,32.7V15.3A1,1,0,0,0,46.707,14.6ZM36,29a8,8,0,0,1-8,8H22.743a8,8,0,0,1-7.019-4.162L11.2,24.571l.006,0a1.733,1.733,0,0,1-.21-.816,1.745,1.745,0,0,1,3.108-1.1l.006,0L18,26.781V12.5a1.5,1.5,0,0,1,3,0V21a1,1,0,0,0,2,0V11.5a1.5,1.5,0,0,1,3,0V21a1,1,0,0,0,2,0V12.5a1.5,1.5,0,0,1,3,0V22a1,1,0,0,0,2,0V16a1.5,1.5,0,0,1,3,0Z" fill="#face00"></path></g></svg>':"Info"===e.audit.severity?'<svg xmlns="http://www.w3.org/2000/svg" alt="Information (Low level severity)" style="display: inline-block;" width="24" height="24" viewBox="0 0 48 48"><title>Information (Low level severity)</title><g fill="#3288d6" stroke-linecap="square" stroke-linejoin="miter" stroke-miterlimit="10"><circle data-stroke="none" cx="24" cy="12" r="1" fill="#3288d6" stroke="none"></circle><circle cx="24" cy="24" r="22" fill="none" stroke="#3288d6" stroke-width="4"></circle><circle cx="24" cy="12" r="1" fill="none" stroke="#3288d6" stroke-width="4"></circle><line x1="24" y1="19" x2="24" y2="36" fill="none" stroke="#3288d6" stroke-width="4"></line></g></svg>':""} ${e.audit.name}</h4><p class="text-base text-slate-400 mb-4">${e.message}</p>`)).join(""))).join("\n")} \n      </div>\n      </section>\n      </main>\n</body>\n</html>`)}function ImageToBase64Tag(e){try{const t=fs_1.default.readFileSync(e);if(!t)return"";return`<div style="text-align:center;" class="mb-4"><img style="max-width:90%;max-height:90%;object-fit:contain;" src="data:image/jpeg;base64,${Buffer.from(t).toString("base64")}" /></div>`}catch(e){return""}}exports.exportTestResultHTML=exportTestResultHTML;