"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,a,s){void 0===s&&(s=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,s,r)}:function(e,t,a,s){void 0===s&&(s=a),e[s]=t[a]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&__createBinding(t,e,a);return __setModuleDefault(t,e),t},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.audits=void 0;const fs_1=__importDefault(require("fs")),urlCache_1=require("./urlCache"),utils=__importStar(require("./utils")),languageTags_1=require("./languageTags");async function validateRobotsTxt(e,t){const a=[];try{const s=await(0,urlCache_1.loadWithCache)(e,t);if(!s.ok)return a.push({line:0,message:`HTTP error loading robots.txt: ${s.status} ${s.statusText}`}),a;const r=await s.text;if(-1!==r.indexOf("<html"))return a.push({message:"robots.txt is an HTML page. It might be a default because the file is missing. Please make sure a robots.txt file is available."}),a;const i=r.split("\n");for(let e=0;e<i.length;e++){const t=i[e];if(""===t.trim()||t.startsWith("#"))continue;const s=t.split(":"),r=s[0].trim().toLowerCase(),n=s.slice(1).join(":").trim();"user-agent"===r?""===n&&a.push({line:e+1,message:"Empty User-Agent value is invalid"}):"disallow"===r||"allow"===r?""===n&&a.push({line:e+1,message:"Empty Disallow or Allow value is invalid"}):"sitemap"===r?""===n&&a.push({line:e+1,message:"Empty Sitemap value is invalid"}):"crawl-delay"===r?isNaN(parseFloat(n))&&a.push({line:e+1,message:"Invalid Crawl-Delay value"}):"host"===r?""===n&&a.push({line:e+1,message:"Empty Host value is invalid"}):"request-rate"===r?""===n&&a.push({line:e+1,message:"Empty Request-Rate value is invalid"}):"visit-time"===r?""===n&&a.push({line:e+1,message:"Empty Visit-Time value is invalid"}):"clean-param"===r?""===n&&a.push({line:e+1,message:"Empty Clean-Param value is invalid"}):"noindex"===r?""===n&&a.push({line:e+1,message:"Empty Noindex value is invalid"}):a.push({line:e+1,message:`Unknown directive: ${r}`})}}catch(e){console.error("Error fetching robots.txt:",e);var s="",r="";e instanceof Error?(s=e.message,r=e.stack):(s="Unknown error",r="Unknown error"),fs_1.default.appendFile("errorLog.txt",`${(new Date).toISOString()}: Error: ${s}. ${r}\n`,(e=>{e&&console.error(e)})),a.push({line:0,message:"Error reading robots.txt"})}return a}function levenshteinDistance(e,t){if(!e.length)return t.length;if(!t.length)return e.length;const a=e.length+1,s=t.length+1,r=Array.from({length:a},(()=>new Array(s).fill(0)));for(let e=0;e<a;e++)r[e][0]=e;for(let e=0;e<s;e++)r[0][e]=e;for(let i=1;i<a;i++)for(let a=1;a<s;a++){const s=e[i-1]===t[a-1]?0:1;r[i][a]=Math.min(r[i-1][a]+1,r[i][a-1]+1,r[i-1][a-1]+s)}return r[a-1][s-1]}exports.audits=[],exports.audits.push({name:"Should have exactly 1 title tag",severity:"Error",premium:!1,test:async e=>{var t=await e.evaluate((()=>Array.from(document.querySelectorAll("title")).filter((e=>"svg"!==e.parentElement?.tagName.toLowerCase())).map((e=>e.text||e.outerHTML))));return{success:1===t.length,message:1===t.length?"Correctly have 1 title tag.":`You should have exactly 1 title tag. Found ${t.length}. Titles found were: `+t.join(", ")+". The title tag is important for SEO and user experience and should be unique for each page. Title tags used for items other than the title of the page can be confusing for search engines."}}}),exports.audits.push({name:"Images should have alt tags",severity:"Warning",premium:!1,test:async e=>{var t=await e.evaluate((()=>Array.from(document.querySelectorAll("img")).filter((e=>!e.attributes.getNamedItem("alt")?.value)).map((e=>({src:e.src,outerHtml:e.outerHTML})))));return{success:0===t.length,message:`Images should have alt tags. Found ${t.length}. Missing alt tags. The alt attribute provides a description of the image for screen readers and search engines. It is important for accessibility and SEO. ${t.map((e=>"<br /><br />"+(e.src||e.outerHtml))).join("")}`}}}),exports.audits.push({name:"Should have a meta description",severity:"Warning",premium:!1,test:async e=>{var t=await e.evaluate((()=>Array.from(document.querySelectorAll('meta[name="description"]'))));return{success:1===t.length,message:`You should have exactly 1 meta description tag. Found ${t.length}.<br /><br />The meta description is used by some search engines to display a snippet of your page in search results. It should be descriptive and concise.`}}}),exports.audits.push({name:"Should not have broken images",severity:"Error",premium:!1,test:async e=>{var t=await e.evaluate((async()=>{var e=Array.from(document.querySelectorAll("img")).filter((e=>0===e.naturalWidth));for(const t of e)t.scrollIntoView(),await new Promise((e=>setTimeout(e,100)));return Array.from(document.querySelectorAll("img")).filter((e=>0===e.naturalWidth)).map((e=>({src:e.src,outerHtml:e.outerHTML})))}));return{success:0===t.length,message:`Found ${t.length} broken images. Broken images can negatively impact user experience and SEO. They will show as an image placeholder that does not look good. Search engines likely use issues like this in their ranking. Make sure all images are loading correctly. ${t.map((e=>"<br /><br />"+(e.src||e.outerHtml))).join("")}.\n          `}}}),exports.audits.push({name:"Page is not a 404 error",premium:!1,severity:"Error",test:async e=>{var t=404!==(await(0,urlCache_1.loadWithCache)(e.url(),"")).status;return{success:t,message:t?"Page is not a 404 error":"Page is a 404 error."}}}),exports.audits.push({name:"Page is not a 4XX error",severity:"Error",premium:!1,test:async e=>{const t=await fetch(e.url());if(null==t)return{success:!1,message:"Error loading page. No response found."};var a=!!t.status&&!t.status.toString().startsWith("4");return{success:a,message:a?"Page is not a 4XX error":`Page is a 4XX error: ${t.status}. ${JSON.stringify(t)}`}}}),exports.audits.push({name:"Page is not a 500 error",severity:"Error",premium:!1,test:async e=>{var t=500!==(await(0,urlCache_1.loadWithCache)(e.url(),"")).status;return{success:t,message:t?"Page is not a 500 error":"Page is a 500 error"}}}),exports.audits.push({name:"Page is not a 5XX error",severity:"Error",premium:!1,test:async e=>{const t=await(0,urlCache_1.loadWithCache)(e.url(),"");var a=!!t.status&&!t.status.toString().startsWith("5");return{success:a,message:a?"Page is not a 5XX error":`Page is a 5XX error: ${t.status}`}}}),exports.audits.push({name:"No mixed HTTPS/HTTP content",severity:"Warning",premium:!1,test:async e=>{var t=utils.distinct(await e.evaluate((()=>Array.from(document.querySelectorAll("img, script, link, iframe")).map((e=>e.getAttribute("src")??e.getAttribute("href")??"")))));if(!t.filter)throw console.log({distinctItems:t}),new Error("distinctItems is not an array. It is of type: "+typeof t+". "+JSON.stringify(t));var a=await e.evaluate((()=>window.location.protocol)),s=t.filter((e=>e.startsWith("http://")?"https:"===a:!!e.startsWith("https://")&&"http:"===a));return{success:0===s.length,message:`Found ${s.length} mixed content links: ${s.join("<br /><br />")}`}}}),exports.audits.push({name:"Should be using https",severity:"Warning",premium:!1,test:async e=>({success:"https:"===await e.evaluate((()=>window.location.protocol)),message:"You should be using https"})}),exports.audits.push({name:"JavaScript should have cache policy",severity:"Info",premium:!1,test:async e=>{const t=(await e.evaluate((()=>Array.from(document.querySelectorAll("script[src]")).map((e=>({src:e.getAttribute("src")??""})))))).filter((t=>utils.isCorsSafeUrl(t.src,e.url()))).map((t=>({url:t.src??"",promise:(0,urlCache_1.loadWithCache)(e.url(),t.src??"")}))),a=(await Promise.all(t.map((e=>e.promise)))).filter((e=>!(e.headers.get("cache-control")??"").includes("max-age")));return{success:0===a.length,message:0===a.length?"All JavaScript files have a cache policy.":`Some JavaScript files are missing a cache policy. This helps browsers know how long to cache the file for. It can improve page load times when long enough. If it is too long it can cause issues when updating the site. ${a.map((e=>"<br /><br />"+e.url)).join("")}`}}}),exports.audits.push({name:"Sitemap includes page",severity:"Warning",premium:!1,test:async e=>{var t=await utils.getSitemapURLs(e.url());if(0===t.length)return{success:!1,message:"Sitemap not found"};var a=await Promise.all(t.map((async t=>{const a=await(0,urlCache_1.loadWithCache)(e.url(),t);if(200!==a.status)return console.log(`Error loading sitemap: ${t} ${a.status}`),null;const s=await a.text;var r=await e.evaluate((e=>{const t=(new DOMParser).parseFromString(e,"text/xml");return Array.from(t.querySelectorAll("url loc")).map((e=>e.textContent))}),s),i=await e.evaluate((()=>window.location.href));const n=r.filter((e=>e===i));return n.length>0?`Sitemap: ${t} URL: ${n?.map((e=>e)).join("<br />")}`:null}))),s=a.filter((e=>null!==e)),r=[];return 0===s.length&&(r=a.filter((e=>null!==e)).map((t=>({item:t,distance:levenshteinDistance(t,e.url())}))).sort(((e,t)=>e.distance-t.distance)).map((e=>e.item)).slice(0,3)),{success:s.length>0,message:s.length>0?"Page is included in the sitemap: "+s.map((e=>"<br /><br />"+e)).join(""):"Page is not included in sitemaps. It is important to be in the sitemap for search engines to easily find your pages."+(r.length>0?" Here are the most similar links. See if there are some that are close."+r.map((e=>"<br /><br />"+e)).join(""):" No links were found in any sitemap. There might be an issue loading sitemaps.")}}}),exports.audits.push({name:"AMP page is valid",severity:"Error",premium:!1,test:async e=>{if(!(await e.evaluate((()=>window.location.pathname))).endsWith(".amp"))return{success:!0,message:"Not an AMP page"};const t=await fetch("https://validator.ampproject.org/validate",{method:"POST",body:await e.evaluate((()=>document.documentElement.outerHTML)),headers:{"Content-Type":"text/html"}}),a="PASS"===(await t.json()).status;return{success:a,message:a?"AMP page is valid":"AMP page validation failed"}}}),exports.audits.push({name:"Sitemaps should each have fewer than 50k URLs",severity:"Warning",premium:!1,test:async e=>{var t=new URL(e.url()).origin,a=await utils.getSitemapURLs(t);if(0===a.length)return{success:!1,message:"Sitemap not found"};var s=Promise.all(a.map((async a=>{const s=await(0,urlCache_1.loadWithCache)(t,a);if(200!==s.status)return{success:!1,message:"Sitemap not found for page. Received an http status of "+s.status};const r=await s.text;var i=await e.evaluate((e=>{const t=(new DOMParser).parseFromString(e,"text/xml");return Array.from(t.querySelectorAll("url loc")).map((e=>e.textContent))}),r),n=i.length<5e4;return{success:n,message:n?`Sitemap ${a} has fewer than 50k URLs. There are ${i.length} URLs.`:`Sitemap ${a} has at least 50k URLs. Sitemap has ${i.length} URLs. Having too many URLs in a sitemap can cause issues with search engines. It is recommended to have fewer than 50k URLs in a sitemap.`}})));return(await s).some((e=>!1===e.success))?{success:!1,message:" "+(await s).filter((e=>!1===e.success)).map((e=>e.message)).join("<br /><br />")}:{success:!0,message:"All sitemaps have fewer than 50k URLs"}}}),exports.audits.push({name:"Sitemaps should be less than 50MB",severity:"Warning",premium:!1,test:async e=>{const t=await(0,urlCache_1.loadWithCache)(e.url(),"/sitemap.xml");var a=(await t.text).length;const s=null!=a&&a<52428800;return{success:s,message:s?`Sitemap is less than 50MB at ${(Math.ceil(a/104857600)/100).toFixed(2)}MB`:`Sitemap is ${(Math.ceil(a/104857600)/100).toFixed(2)}MB.\n            <br /><br />Sitemaps should be less than 50MB. Having a sitemap that is too large can cause issues with search engines.`}}}),exports.audits.push({name:"Sitemap should be in correct format",severity:"Error",premium:!1,test:async e=>{var t=await utils.getSitemapURLs(e.url());if(0===t.length)return{success:!1,message:"Sitemap not found"};var a=t.map((async t=>{const a=await(0,urlCache_1.loadWithCache)(e.url(),t);if(!a.ok)return{success:!1,message:"Sitemap not found"};const s=await a.text;var r=await e.evaluate((e=>null!==(new DOMParser).parseFromString(e,"text/xml").querySelector("urlset")),s);return{success:r,message:r?"Sitemap is in correct format":`Sitemap ${t} is not in correct format.`}}));await Promise.all(a);var s=await Promise.all(a.map((async e=>await e.then((e=>e)))));return s.some((e=>!1===e.success))?{success:!1,message:" "+s.filter((e=>!1===e.success)).map((e=>e.message)).join("<br /><br />")+" If sitemaps can't be parsed by search engines, they won't be used and that will limit the SEO benefits."}:{success:!0,message:"All sitemaps are in correct format"}}}),exports.audits.push({name:"robots.txt should be available",severity:"Warning",premium:!1,test:async e=>(await(0,urlCache_1.loadWithCache)(e.url(),"/robots.txt")).ok?{success:!0,message:"robots.txt found"}:{success:!1,message:"robots.txt not found. This file makes it easier for search engines to know what they can index from your site. It also provides a place where sitemap files can be linked."}}),exports.audits.push({name:"Fewer than 20 linked javascript files",severity:"Warning",premium:!1,test:async e=>{const t=await e.evaluate((()=>Array.from(document.querySelectorAll("script[src]")).map((e=>e.src)))),a=t.length<20;return{success:a,message:a?"Fewer than 20 linked JavaScript files":`Found ${t.length} linked JavaScript files. Having too many JavaScript files can slow down page load times. Consider combining or minifying them. If many are for tracking purposes, see if those can be consolidated into fewer services. ${t.map((e=>"<br /><br />"+e))}          `}}}),exports.audits.push({name:"Should have a page icon",severity:"Warning",premium:!1,test:async e=>{const t=await e.evaluate((()=>document.querySelector('link[rel="icon"]')?.getAttribute("href")));return{success:null!=t,message:t?"Found page icon":"No page icon found. Favicons help users know that they are on the right site. It is recommended to have a favicon."}}}),exports.audits.sort(((e,t)=>"Error"===e.severity&&"Error"!==t.severity?-1:"Error"!==e.severity&&"Error"===t.severity?1:e.name<t.name?-1:e.name>t.name?1:0));