"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.bindPageErrorHandlingAsync=void 0;const playwright_1=require("playwright"),async_lock_1=__importDefault(require("async-lock")),path_1=__importDefault(require("path")),commander_1=require("commander"),audits_1=require("./audits"),utils_1=require("./utils"),fs_1=__importDefault(require("fs")),exportPDF_1=require("./exportPDF"),exportCSV_1=require("./exportCSV"),formatUrlForFilename_1=require("./formatUrlForFilename"),exportHTML_1=require("./exportHTML"),createSitemap_1=require("./createSitemap"),crossPageAudits_1=require("./crossPageAudits"),exportInteractiveHTML_1=require("./exportInteractiveHTML");function parseBoolean(e){return"true"===e.toLowerCase()}commander_1.program.name("SEO Page Audit").description("Crawl a website and run SEO audits on each page.").option("-u, --url <url>","Base URL for the audit").option("-v, --verbose","Verbose output",!1).option("-mp, --maxPages <maxPages>","Max number of pages to crawl",parseInt).option("-md, --maxDepth <maxDepth>","Max depth to crawl",parseInt).option("-s, --includeScreenshot <includeScreenshot>","Include screenshots",parseBoolean,!1).option("-nb, --numberOfBrowsers <numberOfBrowsers>","Number of browsers to use",parseInt),commander_1.program.parse(process.argv);const options=commander_1.program.opts();options.url||(console.error("No URL provided"),process.exit(1));const initialUrl=options.url,maxDepth=options.maxDepth||5,maxPages=options.maxPages||1e3,numberOfBrowsers=options.numberOfBrowsers||4,verboseLogging=options.verbose,includeScreenshot=options.includeScreenshot;var behindLock={workerPool:[],auditResults:[],visitedUrls:new Set,queue:[],errorsPerPage:{},pageDetails:{},crossPageAuditResults:[]},lock=new async_lock_1.default;async function asyncChange(e){return lock.acquire("lock",(async r=>{await e(behindLock),r()}))}function bindPageErrorHandlingAsync(e,r,a){var s;return e.off("pageerror",a),s=async e=>{await asyncChange((async a=>{a.errorsPerPage[r]=`JavaScript error: ${e}`}))},e.on("pageerror",s),e.off("pageerror",a),s}async function processPage(e,r){try{r.pageErrorHandler=bindPageErrorHandlingAsync(r.page,e.url,r.pageErrorHandler);var a=0,s=0;await asyncChange((async e=>{a=e.queue.length,s=e.visitedUrls.size})),console.log(`---------\r\nQueue length: ${a}. Visited: ${s}. Remaining max pages: ${maxPages-s}.\r\nCrawling ${e.url}\r\n---------\r\n`),verboseLog(`Navigating to ${e.url}`),await r.page.goto(e.url,{waitUntil:"load"}),await asyncChange((async a=>{a.pageDetails[e.url]={url:e.url,innerText:await r.page.innerText("html"),innerHTML:await r.page.innerHTML("html")}})),includeScreenshot&&await new Promise((e=>setTimeout(e,2e3))),verboseLog(`Collecting links from ${e.url}`),await enqueuePages(e,await(0,utils_1.collectFollowLinks)(r.page)),verboseLog(`Running page audits for ${e.url}`);var o=await runPageAudits(audits_1.audits,r.page);await asyncChange((async e=>{e.auditResults.push(...o)})),includeScreenshot&&await takeScreenshot(r.page,e.url,(0,formatUrlForFilename_1.formatUrlForFilename)(initialUrl))}catch(r){console.log(`Error processing page: ${e.url}. ${r.message}`),await asyncChange((async a=>{a.auditResults.push({audit:{name:"Error",severity:"Error",premium:!1,test:async()=>({success:!1,message:r.message})},success:!1,message:r.message,url:e.url})}))}return r}async function enqueuePages(e,r){await Promise.all(r.map((async r=>{var a=new URL(r,e.url).href;if((0,utils_1.isCorsSafeUrl)(initialUrl,a))return asyncChange((async r=>{r.visitedUrls.has(a)||(e.depth+1>maxDepth?verboseLog(`Max depth reached for ${a}`):r.queue.filter((e=>e.url===a)).length>0?verboseLog(`Already enqueued: ${a}`):(r.queue.push({url:a,depth:e.depth+1}),verboseLog(`Enqueued ${a} from ${e.url}`)))}));verboseLog(`Not Cors safe: ${a} from ${initialUrl} or ${e.url}`)})))}function verboseLog(e){verboseLogging&&console.log(e)}async function runPageAudits(e,r){const a=[];var s=r.url();for(const n of e){n.premium,0;var o=performance.now();try{const e=n.test(r);if(e instanceof Promise)try{const s={...await e,url:r.url()};a.push({audit:n,...s})}catch(e){console.log(`Error running audit ${n.name}: ${e.message}. ${e.stack}`),-1===e.message.indexOf("undefined")&&-1===e.message.indexOf("DOMParser")||(console.log("Error running audit: "+n.name),fs_1.default.appendFile("errorLog.txt",`${(new Date).toISOString()}: Error running audit ${n.name}: ${e.message}. ${e.stack}\n`,(e=>{e&&console.error(e)}))),a.push({audit:n,success:!1,message:e.message,url:s})}else null!=e?a.push({audit:n,success:e.success,message:e.message,url:s}):a.push({audit:n,success:!1,message:"No result returned",url:s})}catch(e){console.log(`Error running audit ${n.name}: ${e.message}`),fs_1.default.appendFile("errorLog.txt",`${(new Date).toISOString()}: Error: ${e.message}. ${e.stack}\n`,(e=>{e&&console.error(e)})),a.push({audit:n,success:!1,message:e.message,url:s})}var t=performance.now();verboseLogging&&fs_1.default.appendFile("performanceLog.txt",` ${(0,utils_1.formatElapsedTime)(t-o)}: Audit ${n.name}\n`,(e=>{e&&console.error(e)}))}return a}process.on("unhandledRejection",((e,r)=>{console.error("Unhandled Promise Rejection:",e),unhandledPromises.add(r)})),process.on("exit",(()=>{if(unhandledPromises.size>0){console.error(`Found ${unhandledPromises.size} unresolved promises:`);for(const e of unhandledPromises)console.error(e);process.exitCode=1}})),(async()=>{console.log(`----\nStarting crawl of ${initialUrl}. Up to ${maxPages} pages. Up to a depth of ${maxDepth}. Using ${numberOfBrowsers} browsers.\n----\n`);const e=performance.now();for(var r=0;r<numberOfBrowsers;r++){const e=await playwright_1.chromium.launch(),r=await e.newContext({screen:{width:1920,height:1440},viewport:{width:1920,height:1440},bypassCSP:!0}),a=await r.newPage();await asyncChange((async s=>{s.workerPool.push({page:a,context:r,browser:e,pageErrorHandler:()=>{}})}))}await asyncChange((async e=>{e.queue.push({url:initialUrl,depth:0})}));for(var a=0,s=0,o=!1;!1===o&&(a<120||s<2)&&s<maxPages;){var t,n;if(await asyncChange((async e=>{t=e.queue.shift(),s=e.visitedUrls.size})),void 0!==t)if(await asyncChange((async e=>{n=e.workerPool.shift()})),void 0!==n){a=0;var i=t.url;await asyncChange((async e=>{e.visitedUrls.add(i)})),n.currentProcess=processPage(t,n).then((async e=>{e.currentProcess=void 0,await asyncChange((async r=>{r.workerPool.push(e)})),verboseLog("Worker pushed back to pool")})).catch((async e=>{console.log(`Error processing page: ${i}. ${e.message}`),void 0!==n&&(n.currentProcess=void 0,await asyncChange((async e=>{e.workerPool.push(n)})))})),await asyncChange((async e=>{verboseLog(`Queue length: ${e.queue.length}. Visited: ${e.visitedUrls.size}.`)}))}else verboseLog(`Worker pool empty. Waiting for a page to finish. loops: ${a}`),await asyncChange((async e=>{e.queue.push(t)})),await new Promise((e=>setTimeout(e,1e3))),a++;else verboseLog(`Queue empty. Waiting for a page to finish. loops: ${a}`),await new Promise((e=>setTimeout(e,1e3))),a++,await asyncChange((async e=>{if(e.workerPool.length===numberOfBrowsers&&0===e.queue.length&&e.workerPool.every((e=>void 0===e.currentProcess)))return o=!0,void verboseLog(`Breaking main loop. Workers: ${e.workerPool.length}. Queue: ${e.queue.length}. Visited: ${e.visitedUrls.size}. Loops: ${a}.`)}))}await asyncChange((async e=>{verboseLog(`loops: ${a}. queue: ${e.queue.length}. workers: ${e.workerPool.length}. number of browsers: ${numberOfBrowsers}`)})),console.log("Running cross-page audits"),await new Promise((e=>setTimeout(e,20)));var l={};await asyncChange((async e=>{l=e.pageDetails})),await processCrossPageAudits(l);var c=(0,formatUrlForFilename_1.formatUrlForFilename)(initialUrl),u=new Date,g=`${u.toLocaleString("default",{year:"numeric"})}-${u.toLocaleString("default",{month:"2-digit"})}-${u.toLocaleString("default",{day:"2-digit"})}`,d="results/"+c+"/";fs_1.default.existsSync(d)||fs_1.default.mkdirSync(d,{recursive:!0});try{await asyncChange((async e=>{await(0,exportCSV_1.exportTestResultCSVv2)(e.auditResults,e.crossPageAuditResults,d+`audit_${c}_${g}.csv`)})),console.log("CSV exported")}catch(e){console.log(e),fs_1.default.appendFile("errorLog.txt",`${(new Date).toISOString()}: Error saving HTML: ${e.message}. ${e.stack}\n`,(e=>{e&&console.error(e)}))}try{await asyncChange((async e=>{await(0,exportHTML_1.exportTestResultHTML)(e.visitedUrls.size,e.auditResults,e.crossPageAuditResults,d+`audit_${c}_${g}.html`,initialUrl)})),console.log("HTML exported")}catch(e){console.log(e),fs_1.default.appendFile("errorLog.txt",`${(new Date).toISOString()}: Error saving HTML: ${e.message}. ${e.stack}\n`,(e=>{e&&console.error(e)}))}try{await asyncChange((async e=>{await(0,exportInteractiveHTML_1.exportInteractiveTestResultHTML)(e.visitedUrls.size,e.auditResults,e.crossPageAuditResults,d+`audit_${c}_${g}_Interactive.html`,initialUrl)})),console.log("HTML Interactive exported")}catch(e){console.log(e),fs_1.default.appendFile("errorLog.txt",`${(new Date).toISOString()}: Error saving HTML: ${e.message}. ${e.stack}\n`,(e=>{e&&console.error(e)}))}try{await asyncChange((async e=>{await(0,exportPDF_1.exportTestResultPDF)(e.visitedUrls.size,e.auditResults,e.crossPageAuditResults,d+`audit_${c}_${g}.pdf`,initialUrl)})),console.log("PDF exported")}catch(e){console.log(e),fs_1.default.appendFile("errorLog.txt",`${(new Date).toISOString()}: Error saving PDF: ${e.message}. ${e.stack}\n`,(e=>{e&&console.error(e)}))}var p=initialUrl;p.endsWith("/")&&(p=p.slice(0,-1)),fs_1.default.writeFileSync(d+"robots.txt","User-agent: *\nAllow: / \n\nSitemap: "+p+"/sitemap.xml");var m=new Set;await asyncChange((async e=>{m=e.visitedUrls})),(0,createSitemap_1.createSitemap)(p,Array.from(m).map((e=>({path:e}))),d+"sitemap.xml"),await asyncChange((async e=>{e.workerPool.forEach((async e=>{await e.context.close(),await e.browser.close()}))}));let h=0;await asyncChange((async e=>{h=Object.keys(e.auditResults.reduce(((e,r)=>(e[r.url]=(e[r.url]||0)+1,e)),{})).length}));var f=[];m=new Set;await asyncChange((async e=>{f=e.auditResults,m=e.visitedUrls})),await cleanUpScreenshots(d),console.log(`${f.filter((e=>!1===e.success)).length} failed audits.\n${f.filter((e=>!0===e.success)).length} successful audits.\n${m.size} pages visited.\n${h} pages with audit results.\nFinished crawling in ${(0,utils_1.formatElapsedTime)(performance.now()-e)}.`)})().then((()=>{console.log("Done"),process.exit(0)})).catch((e=>{console.log("Error: "+e),process.exit(1)})),exports.bindPageErrorHandlingAsync=bindPageErrorHandlingAsync;const unhandledPromises=new Set;async function processCrossPageAudits(e){var r=Object.keys(e).map((r=>e[r])),a=(await Promise.all(crossPageAudits_1.crossPageAuditTests.map((async e=>await e(r,initialUrl))))).flat();await asyncChange((async e=>{e.crossPageAuditResults.push(...a)}))}async function takeScreenshot(e,r,a){try{await e.route((e=>[".ttf",".otf",".woff",".woff2","eot","svg"].some((r=>-1!==e.href.toLocaleLowerCase().indexOf(r)))),(e=>{verboseLog(`Routing: ${e.request().url()}`),e.abort()}),{times:1}),await e.screenshot({path:`results/${a}/${(0,formatUrlForFilename_1.formatUrlForFilename)(r)}.jpeg`,fullPage:!1,type:"jpeg",quality:50,timeout:1e4}),await e.route((e=>[".ttf",".otf",".woff",".woff2","eot","svg"].some((r=>-1!==e.href.toLocaleLowerCase().indexOf(r)))),(e=>{e.continue()}))}catch(e){console.log(`Error taking screenshot: ${e.message}`)}}async function cleanUpScreenshots(e){var r=path_1.default.resolve(e);try{const e=fs_1.default.readdirSync(r);for(const a of e){const e=path_1.default.join(r,a);a.toLowerCase().endsWith(".jpeg".toLowerCase())&&fs_1.default.unlinkSync(e)}}catch(e){console.error("Error:",e)}}